/*
 * Globalize Culture zh-CN
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "zh-CN", "default", {
	name: "zh-CN",
	englishName: "Chinese (Simplified, PRC)",
	nativeName: "中文(中华人民共和国)",
	language: "zh-CHS",
	numberFormat: {
		"NaN": "非数字",
		negativeInfinity: "负无穷大",
		positiveInfinity: "正无穷大",
		percent: {
			pattern: ["-n%","n%"]
		},
		currency: {
			pattern: ["$-n","$n"],
			symbol: "¥"
		}
	},
	calendars: {
		standard: {
			days: {
				names: ["星期日","星期一","星期二","星期三","星期四","星期五","星期六"],
				namesAbbr: ["周日","周一","周二","周三","周四","周五","周六"],
				namesShort: ["日","一","二","三","四","五","六"]
			},
			months: {
				names: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""],
				namesAbbr: ["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月",""]
			},
			AM: ["上午","上午","上午"],
			PM: ["下午","下午","下午"],
			eras: [{"name":"公元","start":null,"offset":0}],
			patterns: {
				d: "yyyy/M/d",
				D: "yyyy'年'M'月'd'日'",
				t: "H:mm",
				T: "H:mm:ss",
				f: "yyyy'年'M'月'd'日' H:mm",
				F: "yyyy'年'M'月'd'日' H:mm:ss",
				M: "M'月'd'日'",
				Y: "yyyy'年'M'月'"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "用户",
  "filetype_box user": "用户",
  "html": "HTML 文件",
  "filetype_html": "HTML 文件",
  "wiki": "维基百科",
  "filetype_wiki": "维基百科",
  "webscraperwebpage": "网页",
  "filetype_webscraperwebpage": "网页",
  "image": "图片",
  "filetype_image": "图片",
  "folder": "文件夹",
  "filetype_folder": "文件夹",
  "txt": "文本",
  "filetype_txt": "文本",
  "zip": "Zip 文件",
  "filetype_zip": "Zip 文件",
  "olefile": "OLE 文件",
  "filetype_olefile": "OLE 文件",
  "gmailmessage": "Gmail 消息",
  "filetype_gmailmessage": "Gmail 消息",
  "pdf": "PDF 文件",
  "filetype_pdf": "PDF 文件",
  "swf": "Flash 文件",
  "filetype_swf": "Flash 文件",
  "xml": "XML 文件",
  "filetype_xml": "XML 文件",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "打开 Office",
  "filetype_svm": "打开 Office",
  "rssitem": "RSS 源",
  "filetype_rssitem": "RSS 源",
  "doc": "文档",
  "filetype_doc": "文档",
  "docx": "Microsoft Word 文档",
  "filetype_docx": "Microsoft Word 文档",
  "xls": "电子数据表文档",
  "filetype_xls": "电子数据表文档",
  "ppt": "演示文档",
  "filetype_ppt": "演示文档",
  "video": "视频",
  "filetype_video": "视频",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "打开文本文档",
  "filetype_odt": "打开文本文档",
  "lithiummessage": "Lithium 消息",
  "filetype_lithiummessage": "Lithium 消息",
  "lithiumthread": "Lithium 线程",
  "filetype_lithiumthread": "Lithium 线程",
  "lithiumboard": "Lithium 保护板",
  "filetype_lithiumboard": "Lithium 保护板",
  "lithiumcategory": "Lithium 类别",
  "filetype_lithiumcategory": "Lithium 类别",
  "lithiumcommunity": "Lithium 社区",
  "filetype_lithiumcommunity": "Lithium 社区",
  "people": "用户",
  "objecttype_people": "用户",
  "message": "消息",
  "objecttype_message": "消息",
  "feed": "RSS 源",
  "objecttype_feed": "RSS 源",
  "thread": "线程",
  "objecttype_thread": "线程",
  "file": "文件",
  "objecttype_file": "文件",
  "board": "保护板",
  "objecttype_board": "保护板",
  "category": "类别",
  "objecttype_category": "类别",
  "account": "账户",
  "objecttype_account": "账户",
  "annotation": "注释",
  "objecttype_annotation": "注释",
  "campaign": "活动",
  "objecttype_campaign": "活动",
  "case": "案例",
  "objecttype_case": "案例",
  "contact": "联系",
  "objecttype_contact": "联系",
  "contract": "合同",
  "objecttype_contract": "合同",
  "event": "事件",
  "objecttype_event": "事件",
  "email": "电子邮件",
  "objecttype_email": "电子邮件",
  "goal": "目标",
  "objecttype_goal": "目标",
  "objecttype_incident": "案例",
  "invoice": "账单",
  "objecttype_invoice": "账单",
  "lead": "带领",
  "objecttype_lead": "带领",
  "list": "列表",
  "objecttype_list": "市场列表",
  "solution": "解决方案",
  "objecttype_solution": "解决方案",
  "task": "任务",
  "objecttype_task": "任务",
  "user": "用户",
  "objecttype_user": "用户",
  "attachment": "附件",
  "objecttype_attachment": "附件",
  "casecomment": "案例意见",
  "objecttype_casecomment": "案例意见",
  "opportunity": "机会",
  "objecttype_opportunity": "机会",
  "opportunityproduct": "机会产品",
  "objecttype_opportunityproduct": "机会产品",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注释",
  "objecttype_note": "注释",
  "product": "产品",
  "objecttype_product": "产品",
  "partner": "合作伙伴",
  "objecttype_partner": "合作伙伴",
  "queueitem": "列队项目",
  "objecttype_queueitem": "列队项目",
  "quote": "引用",
  "objecttype_quote": "引用",
  "salesliterature": "销售说明书",
  "objecttype_salesliterature": "销售说明书",
  "salesorder": "销售订单",
  "objecttype_salesorder": "销售订单",
  "service": "服务",
  "objecttype_service": "服务",
  "socialprofile": "社会形象",
  "objecttype_socialprofile": "社会形象",
  "kbdocumentation": "文件",
  "objecttype_kbdocumentation": "文件",
  "kbtechnicalarticle": "文件",
  "objecttype_kbtechnicalarticle": "文件",
  "kbsolution": "解决方案",
  "objecttype_kbsolution": "解决方案",
  "kbknowledgearticle": "知识文章",
  "objecttype_kbknowledgearticle": "知识文章",
  "kbattachment": "附件",
  "objecttype_kbattachment": "附件",
  "kbarticle": "文章",
  "objecttype_kbarticle": "文章",
  "kbarticlecomment": "文章评论",
  "objecttype_kbarticlecomment": "文章评论",
  "knowledgearticle": "知识文章",
  "objecttype_knowledgearticle": "知识文章",
  "topic": "主题",
  "objecttype_topic": "主题",
  "dashboard": "仪表板",
  "objecttype_dashboard": "仪表板",
  "contentversion": "文档",
  "objecttype_contentversion": "文档",
  "collaborationgroup": "协作组",
  "objecttype_collaborationgroup": "协作组",
  "spportal": "入口",
  "filetype_spportal": "入口",
  "spsite": "站点",
  "filetype_spsite": "站点",
  "spuserprofile": "SharePoint 用户",
  "filetype_spuserprofile": "SharePoint 用户",
  "sparea": "区域",
  "filetype_sparea": "区域",
  "spannouncement": "公告",
  "filetype_spannouncement": "公告",
  "spannouncementlist": "公告",
  "filetype_spannouncementlist": "公告",
  "spcontact": "联系",
  "filetype_spcontact": "联系",
  "spcontactlist": "联系",
  "filetype_spcontactlist": "联系",
  "spcustomlist": "自定义列表",
  "filetype_spcustomlist": "自定义列表",
  "spdiscussionboard": "讨论板块",
  "filetype_spdiscussionboard": "讨论板块",
  "spdiscussionboardlist": "讨论板块",
  "filetype_spdiscussionboardlist": "讨论板块",
  "spdocumentlibrarylist": "文档库",
  "filetype_spdocumentlibrarylist": "文档库",
  "spevent": "事件",
  "filetype_spevent": "事件",
  "speventlist": "事件",
  "filetype_speventlist": "事件",
  "spformlibrarylist": "从库",
  "filetype_spformlibrarylist": "从库",
  "spissue": "问题",
  "filetype_spissue": "问题",
  "spissuelist": "问题",
  "filetype_spissuelist": "问题",
  "splink": "链接",
  "filetype_splink": "链接",
  "splinklist": "链接",
  "filetype_splinklist": "链接",
  "sppicturelibrarylist": "图片库",
  "filetype_sppicturelibrarylist": "图片库",
  "spsurvey": "调查",
  "filetype_spsurvey": "调查",
  "spsurveylist": "调查",
  "filetype_spsurveylist": "调查",
  "sptask": "任务",
  "filetype_sptask": "任务",
  "sptasklist": "任务",
  "filetype_sptasklist": "任务",
  "spagenda": "议程",
  "filetype_spagenda": "议程",
  "spagendalist": "议程",
  "filetype_spagendalist": "议程",
  "spattendee": "参会人",
  "filetype_spattendee": "参会人",
  "spattendeelist": "参会人",
  "filetype_spattendeelist": "参会人",
  "spcustomgridlist": "自定义网格",
  "filetype_spcustomgridlist": "自定义网格",
  "spdecision": "决定",
  "filetype_spdecision": "决定",
  "spdecisionlist": "决定",
  "filetype_spdecisionlist": "决定",
  "spobjective": "目的",
  "filetype_spobjective": "目的",
  "spobjectivelist": "目的",
  "filetype_spobjectivelist": "目的",
  "sptextbox": "文本框",
  "filetype_sptextbox": "文本框",
  "sptextboxlist": "文本框列表",
  "filetype_sptextboxlist": "文本框列表",
  "spthingstobring": "议题",
  "filetype_spthingstobring": "议题",
  "spthingstobringlist": "议题",
  "filetype_spthingstobringlist": "议题",
  "sparealisting": "区域列表",
  "filetype_sparealisting": "区域列表",
  "spmeetingserie": "会议系列",
  "filetype_spmeetingserie": "会议系列",
  "spmeetingserielist": "会议系列列表",
  "filetype_spmeetingserielist": "会议系列列表",
  "spsitedirectory": "站点目录项",
  "filetype_spsitedirectory": "站点目录项",
  "spsitedirectorylist": "站点目录",
  "filetype_spsitedirectorylist": "站点目录",
  "spdatasource": "数据源",
  "filetype_spdatasource": "数据源",
  "spdatasourcelist": "数据源列表",
  "filetype_spdatasourcelist": "数据源列表",
  "splisttemplatecataloglist": "列表模板库",
  "filetype_splisttemplatecataloglist": "列表模板库",
  "spwebpartcataloglist": "WebPart库",
  "filetype_spwebpartcataloglist": "WebPart库",
  "spwebtemplatecataloglist": "站点模板库",
  "filetype_spwebtemplatecataloglist": "站点模板库",
  "spworkspacepagelist": "工作区页面",
  "filetype_spworkspacepagelist": "工作区页面",
  "spunknownlist": "自定义列表",
  "filetype_spunknownlist": "自定义列表",
  "spadministratortask": "管理员任务",
  "filetype_spadministratortask": "管理员任务",
  "spadministratortasklist": "管理员任务",
  "filetype_spadministratortasklist": "管理员任务",
  "spareadocumentlibrarylist": "区域文档库",
  "filetype_spareadocumentlibrarylist": "区域文档库",
  "spblogcategory": "博客分类",
  "filetype_spblogcategory": "博客分类",
  "spblogcategorylist": "博客分类",
  "filetype_spblogcategorylist": "博客分类",
  "spblogcomment": "博客评论",
  "filetype_spblogcomment": "博客评论",
  "spblogcommentlist": "博客评论",
  "filetype_spblogcommentlist": "博客评论",
  "spblogpost": "博客帖子",
  "filetype_spblogpost": "博客帖子",
  "spblogpostlist": "博客帖子",
  "filetype_spblogpostlist": "博客帖子",
  "spdataconnectionlibrarylist": "数据连接库",
  "filetype_spdataconnectionlibrarylist": "数据连接库",
  "spdistributiongroup": "通讯组",
  "filetype_spdistributiongroup": "通讯组",
  "spdistributiongrouplist": "通讯组",
  "filetype_spdistributiongrouplist": "通讯组",
  "spipfslist": "InfoPath 表格服务器",
  "filetype_spipfslist": "InfoPath 表格服务器",
  "spkeyperformanceindicator": "关键性能指示器",
  "filetype_spkeyperformanceindicator": "关键性能指示器",
  "spkeyperformanceindicatorlist": "关键性能指示器",
  "filetype_spkeyperformanceindicatorlist": "关键性能指示器",
  "splanguagesandtranslator": "语言和翻译",
  "filetype_splanguagesandtranslator": "语言和翻译",
  "splanguagesandtranslatorlist": "语言和翻译",
  "filetype_splanguagesandtranslatorlist": "语言和翻译",
  "spmasterpagescataloglist": "主页面库",
  "filetype_spmasterpagescataloglist": "主页面库",
  "spnocodeworkflowlibrarylist": "无代码工作流程库",
  "filetype_spnocodeworkflowlibrarylist": "无代码工作流程库",
  "spprojecttask": "项目任务",
  "filetype_spprojecttask": "项目任务",
  "spprojecttasklist": "项目任务",
  "filetype_spprojecttasklist": "项目任务",
  "sppublishingpageslibrarylist": "页面库",
  "filetype_sppublishingpageslibrarylist": "页面库",
  "spreportdocumentlibrarylist": "报告文档库",
  "filetype_spreportdocumentlibrarylist": "报告文档库",
  "spreportlibrarylist": "报告库",
  "filetype_spreportlibrarylist": "报告库",
  "spslidelibrarylist": "滑动库",
  "filetype_spslidelibrarylist": "滑动库",
  "sptab": "标签",
  "filetype_sptab": "标签",
  "sptablist": "标签列表",
  "filetype_sptablist": "标签列表",
  "sptranslationmanagementlibrarylist": "翻译管理库",
  "filetype_sptranslationmanagementlibrarylist": "翻译管理库",
  "spuserinformation": "用户信息",
  "filetype_spuserinformation": "用户信息",
  "spuserinformationlist": "用户信息列表",
  "filetype_spuserinformationlist": "用户信息列表",
  "spwikipagelibrarylist": "维基百科页面库",
  "filetype_spwikipagelibrarylist": "维基百科页面库",
  "spworkflowhistory": "工作流程历史",
  "filetype_spworkflowhistory": "工作流程历史",
  "spworkflowhistorylist": "工作流程历史列表",
  "filetype_spworkflowhistorylist": "工作流程历史列表",
  "spworkflowprocess": "自定义工作流过程",
  "filetype_spworkflowprocess": "自定义工作流过程",
  "spworkflowprocesslist": "自定义工作流过程",
  "filetype_spworkflowprocesslist": "自定义工作流过程",
  "sppublishingimageslibrarylist": "发布图像库",
  "filetype_sppublishingimageslibrarylist": "发布图像库",
  "spcirculation": "循环",
  "filetype_spcirculation": "循环",
  "spcirculationlist": "循环",
  "filetype_spcirculationlist": "循环",
  "spdashboardslibrarylist": "仪表板库",
  "filetype_spdashboardslibrarylist": "仪表板库",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 数据连接库",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 数据连接库",
  "sphealthreport": "健康报告",
  "filetype_sphealthreport": "健康报告",
  "sphealthreportlist": "健康报告",
  "filetype_sphealthreportlist": "健康报告",
  "sphealthrule": "健康规则",
  "filetype_sphealthrule": "健康规则",
  "sphealthrulelist": "健康规则",
  "filetype_sphealthrulelist": "健康规则",
  "spimedictionary": "IME 字典",
  "filetype_spimedictionary": "IME 字典",
  "spimedictionarylist": "IME 字典",
  "filetype_spimedictionarylist": "IME 字典",
  "spperformancepointcontent": "PerformancePoint 内容",
  "filetype_spperformancepointcontent": "PerformancePoint 内容",
  "spperformancepointcontentlist": "PerformancePoint 内容",
  "filetype_spperformancepointcontentlist": "PerformancePoint 内容",
  "spphonecallmemo": "电话通话备忘录",
  "filetype_spphonecallmemo": "电话通话备忘录",
  "spphonecallmemolist": "电话通话备忘录",
  "filetype_spphonecallmemolist": "电话通话备忘录",
  "sprecordlibrarylist": "记录库",
  "filetype_sprecordlibrarylist": "记录库",
  "spresource": "资源",
  "filetype_spresource": "资源",
  "spresourcelist": "资源",
  "filetype_spresourcelist": "资源",
  "spprocessdiagramslibrarylist": "流程图库",
  "filetype_spprocessdiagramslibrarylist": "流程图库",
  "spsitethemeslibrarylist": "站点主题库",
  "filetype_spsitethemeslibrarylist": "站点主题库",
  "spsolutionslibrarylist": "解决方案库",
  "filetype_spsolutionslibrarylist": "解决方案库",
  "spwfpublibrarylist": "WFPUB 库",
  "filetype_spwfpublibrarylist": "WFPUB 库",
  "spwhereabout": "行踪",
  "filetype_spwhereabout": "行踪",
  "spwhereaboutlist": "行踪",
  "filetype_spwhereaboutlist": "行踪",
  "spdocumentlink": "链接到文档",
  "filetype_spdocumentlink": "链接到文档",
  "spdocumentset": "文件组",
  "filetype_spdocumentset": "文件组",
  "spmicrofeedpost": "Microfeed 帖子",
  "filetype_spmicrofeedpost": "Microfeed 帖子",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "列表文件夹",
  "filetype_splistfolder": "列表文件夹",
  "Unknown": "未知",
  "And": "与",
  "Authenticating": "验证 {0}...",
  "Clear": "清除 {0}",
  "CompleteQuery": "完整查询",
  "Exclude": "排除 {0}",
  "EnterTag": "添加标记",
  "Next": "下一页",
  "Last": "最后一页",
  "Link": "链接",
  "Or": "或",
  "Previous": "上一页",
  "QueryDidntMatchAnyDocuments": "您的查询与任何文档都不匹配。",
  "QueryException": "您的查询存在错误： {0}。",
  "Me": "我",
  "Remove": "删除",
  "Search": "搜索",
  "SearchFor": "搜索 {0}",
  "ShareQuery": "共享查询",
  "Preferences": "首选项",
  "LinkOpeningSettings": "链接打开设置",
  "Reauthenticate": "重新验证 {0}",
  "ResultsFilteringExpression": "结果筛选表达式",
  "FiltersInYourPreferences": "首选项中的筛选条件",
  "Create": "创建",
  "SearchIn": "在 {0} 中搜索",
  "Seconds": "用时 {0} 秒",
  "ShowingResultsOf": "结果数 {0}<pl>-{1}</pl>，总数 {2}",
  "ShowingResultsOfWithQuery": "结果数 {0}<pl>-{1}</pl>，总数 {2}, 搜索 {3}",
  "SwitchTo": "切换到 {0}",
  "Unexclude": "不排除 {0}",
  "ClearAllFilters": "清除所有筛选条件",
  "SkipLogin": "跳过登录",
  "LoginInProgress": "正在登录，请稍候...",
  "Login": "登录",
  "GetStarted": "开始体验",
  "More": "更多",
  "NMore": "{0} 更多...",
  "Less": "更少",
  "Settings": "设置",
  "Score": "得分",
  "ScoreDescription": "得分是根据出现次数和在结果集中的位置计算得来。",
  "Occurrences": "出现次数",
  "OccurrencesDescription": "按出现次数排序，出现次数最高的值排在首位。",
  "Label": "标签",
  "Of": "第...个，共...个",
  "LabelDescription": "对字段值按字母顺序排序。",
  "Value": "值",
  "ValueDescription": "按第一个计算得出的字段的值排序",
  "AlphaAscending": "值升序排序",
  "AlphaDescending": "值降序排序",
  "ChiSquare": "卡方值",
  "Nosort": "无排序",
  "NosortDescription": "不排序值。值将返回随机顺序排列。",
  "RelativeFrequency": "相对频率",
  "RelativeFrequencyDescription": "基于值的相对频率排序。较不常见的值将出现在较高位置。",
  "DateDistribution": "日期分布",
  "Custom": "自定义",
  "CustomDescription": "基于自定义顺序排序",
  "ComputedField": "计算得出的字段",
  "Ascending": "升序",
  "Descending": "降序",
  "noResultFor": "没有找到与 {0} 相关的结果",
  "autoCorrectedQueryTo": "查询自动更正为 {0}",
  "didYouMean": "您要找的是不是： {0}",
  "SuggestedResults": "建议的结果",
  "SuggestedQueries": "建议的查询",
  "MostRelevantItems": "最相关的项：",
  "AllItems": "所有项：",
  "ShowLess": "显示较少的值",
  "ShowMore": "显示较多的值",
  "HideFacet": "隐藏快捷控制界面",
  "ShowFacet": "显示快捷控制界面",
  "AndOthers": "以及 {0} 个其他项",
  "Others": "{0} 个其他项",
  "MostRelevantPosts": "最相关的帖子：",
  "CompleteThread": "完整的主题：",
  "ShowCompleteThread": "显示完整的主题",
  "ShowOnlyTopMatchingPosts": "仅显示最匹配的帖子",
  "MostRelevantReplies": "最相关的回复：",
  "AllConversation": "所有对话：",
  "ShowAllConversation": "显示所有对话",
  "ShowAllReplies": "显示所有回复",
  "ShowOnlyMostRelevantReplies": "仅显示最相关的回复",
  "Close": "关闭",
  "Open": "打开",
  "OpenInOutlookWhenPossible": "在 Outlook 中打开（如果可能）",
  "AlwaysOpenInNewWindow": "总是在新窗口中打开结果",
  "Quickview": "快速查看",
  "NoQuickview": "该文件无法快速浏览。",
  "ErrorReport": "错误报告",
  "OopsError": "服务器出现了错误。",
  "ProblemPersists": "如果问题仍然存在，请联系管理员。",
  "GoBack": "返回",
  "Reset": "重置",
  "Retry": "重试",
  "MoreInfo": "更多信息",
  "Username": "用户名",
  "Password": "密码",
  "PostedBy": "发贴者",
  "CannotConnect": "无法连接到该服务器地址。",
  "BadUserPass": "密码与用户名不匹配。",
  "PleaseEnterYourCredentials": "请输入您的 {0} 凭据。",
  "PleaseEnterYourSearchPage": "请输入您的搜索页面的网址",
  "Collapse": "折叠",
  "Collapsable": "可折叠",
  "Expand": "展开",
  "Today": "今天",
  "Yesterday": "昨天",
  "Tomorrow": "明天",
  "Duration": "持续时间： {0}",
  "IndexDuration": "索引持续时间： {0}",
  "ProxyDuration": "代理持续时间： {0}",
  "ClientDuration": "客户端持续时间： {0}",
  "Unavailable": "不可用",
  "Reply": "回复",
  "ReplyAll": "全部回复",
  "Forward": "转发",
  "From": "发件人",
  "Caption": "标题",
  "Expression": "表达式",
  "Tab": "选项卡",
  "Tabs": "多个选项卡",
  "EnterExpressionName": "输入表达式名称",
  "EnterExpressionToFilterWith": "输入用于筛选结果的表达式",
  "SelectTab": "选择选项卡",
  "SelectAll": "全选",
  "PageUrl": "搜索页面的网址",
  "ErrorSavingToDevice": "在将信息保存到您的设备时出错",
  "ErrorReadingFromDevice": "在从您的设备读取信息时出错",
  "AppIntro": "咨询能够回答您有关 Coveo 的问题的产品专家，并帮助您确定哪个 Coveo 解决方案适合您。或者，尝试现场演示！",
  "TryDemo": "尝试演示",
  "ContactUs": "联系我们",
  "NewToCoveo": "Coveo 的新用户？",
  "LetUsHelpGetStarted": "让我们帮助您开始体验",
  "LikesThis": "{0} 喜欢此解决方案。",
  "CannotConnectSearchPage": "无法连接到您的搜索页面",
  "AreYouSureDeleteFilter": "您是否确定要删除采用 {1} 表达式的筛选条件 {0}",
  "OnlineHelp": "在线帮助",
  "Done": "完成",
  "SaveFacetState": "保存此快捷控制界面状态",
  "ClearFacetState": "清除快捷控制界面状态",
  "DisplayingTheOnlyMessage": "仅显示此对话中的消息",
  "NoNetworkConnection": "没有网络连接",
  "UnknownConnection": "未知的连接",
  "EthernetConnection": "以太网连接",
  "WiFi": "WiFi 连接",
  "CELL": "移动连接",
  "CELL_2G": "移动 2G 连接",
  "CELL_3G": "移动 3G 连接",
  "CELL_4G": "移动 4G 连接",
  "Relevance": "关联",
  "Date": "日期",
  "Amount": "数量",
  "QueryExceptionNoException": "没有例外",
  "QueryExceptionInvalidSyntax": "无效语法",
  "QueryExceptionInvalidCustomField": "无效自定义字段",
  "QueryExceptionInvalidDate": "无效日期",
  "QueryExceptionInvalidExactPhrase": "无效精确短语",
  "QueryExceptionInvalidDateOp": "无效日期运算符",
  "QueryExceptionInvalidNear": "无效 NEAR 运算符",
  "QueryExceptionInvalidWeightedNear": "无效加权 NEAR",
  "QueryExceptionInvalidTerm": "无效条件",
  "QueryExceptionTooManyTerms": "太多条件",
  "QueryExceptionWildcardTooGeneral": "通配符太常见",
  "QueryExceptionInvalidSortField": "无效排序字段",
  "QueryExceptionInvalidSmallStringOp": "无效小字符串运算符",
  "QueryExceptionRequestedResultsMax": "要求的最大结果数",
  "QueryExceptionAggregatedMirrorDead": "远程聚合镜像处于离线状态",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "远程聚合镜像查询超时",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "远程聚合镜像无效版本号",
  "QueryExceptionAggregatedMirrorCannotConnect": "远程聚合镜像无法连接",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主字符通配符不足",
  "QueryExceptionSecurityInverterNotFound": "未找到安全变换器",
  "QueryExceptionSecurityInverterAccessDenied": "安全变换器访问被拒绝",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "远程聚合镜像无法模拟",
  "QueryExceptionUnexpected": "意外",
  "QueryExceptionAccessDenied": "访问被拒绝",
  "QueryExceptionSuperUserTokenInvalid": "超级用户令牌无效",
  "QueryExceptionSuperUserTokenExpired": "超级用户令牌已过期",
  "QueryExceptionLicenseQueriesExpired": "查询许可证已过期",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "许可证超级用户令牌不支持",
  "QueryExceptionInvalidSession": "无效会话",
  "QueryExceptionInvalidDocument": "无效文档",
  "QueryExceptionSearchDisabled": "搜索被禁用",
  "FileType": "文件类型",
  "ShowAttachment": "显示附件",
  "OnFeed": "有关 {0} 的输入。",
  "Author": "作者",
  "NoTitle": "无标题",
  "CurrentSelections": "当前选择",
  "AllContent": "所有内容",
  "CancelLastAction": "取消最后一个动作",
  "SearchTips": "搜索提示",
  "CheckSpelling": "检查关键字的拼写。",
  "TryUsingFewerKeywords": "尝试使用更少、更常用或不同的关键字。",
  "SelectFewerFilters": "选择较少的筛选条件以扩大您的搜索范围。",
  "Document": "文件",
  "Time": "时间",
  "StartDate": "开始日期",
  "StartTime": "开始时间",
  "DurationTitle": "持续时间",
  "UserQuery": "用户查询",
  "ShowUserActions": "显示用户指令",
  "NoData": "无有效数据",
  "EventType": "事件类型",
  "GoToFullSearch": "全面搜索",
  "GoToEdition": "自定义界面",
  "RemoveContext": "清除内容",
  "BoxAttachToCase": "为案例添加附件",
  "AttachToCase": "为案例添加附件",
  "Attach": "附件",
  "Attached": "已添加附件",
  "Detach": "分离",
  "Details": "详细信息",
  "AdditionalFilters": "附加筛选器",
  "SelectNonContextualSearch": "从当前记录中清除内容，以扩大您的搜索",
  "CopyPasteToSupport": "复制并粘贴该消息至 Coveo 支持团队，以获取更多信息。",
  "FollowQueryDescription": "通知我更改查询结果。",
  "SearchAlerts_Panel": "管理通知",
  "SearchAlerts_PanelDescription": "查看并管理您的搜索通知。",
  "SearchAlerts_PanelNoSearchAlerts": "您尚未订阅。",
  "SearchAlerts_Fail": "当前搜索通知不可用。",
  "SearchAlerts_Type": "类型",
  "SearchAlerts_Content": "内容",
  "SearchAlerts_Actions": "指令",
  "EmptyQuery": "<empty>",
  "SearchAlerts_Type_followQuery": "查询",
  "SearchAlerts_Type_followDocument": "项目",
  "SearchAlerts_unFollowing": "停止遵循",
  "SearchAlerts_follow": "遵循",
  "SearchAlerts_followed": "已遵循",
  "SearchAlerts_followQuery": "遵循查询",
  "Subscription_StopFollowingQuery": "停止遵循查询",
  "SearchAlerts_Frequency": "时间",
  "SubscriptionsManageSubscriptions": "管理通知",
  "SubscriptionsMessageFollowQuery": "当查询 <b>{0}</b> 返回新项目或更新项目时，您将会收到通知。",
  "SubscriptionsMessageFollow": "您将会收到更改项目 <b>{0}</b> 的通知。",
  "Expiration": "到期时间",
  "Monthly": "月度",
  "Daily": "日常",
  "Monday": "星期一",
  "Tuesday": "星期二",
  "Wednesday": "星期三",
  "Thursday": "星期四",
  "Friday": "星期五",
  "Saturday": "星期六",
  "Sunday": "星期日",
  "NextDay": "下个 {0}",
  "LastDay": "上个 {0}",
  "StartTypingCaseForSuggestions": "描述您的问题，以查看可能的解决方案",
  "ExportToExcel": "导出到 Excel",
  "ExportToExcelDescription": "导出搜索结果到 Excel",
  "CaseCreationNoResults": "未找到可推荐的解决方案。",
  "SortBy": "排序方式",
  "BoxCreateArticle": "创建文章",
  "Facets": "小平面",
  "AdvancedSearch": "高级搜索",
  "Keywords": "关键词",
  "AllTheseWords": "全部词",
  "ExactPhrase": "精确匹配",
  "AnyOfTheseWords": "任意词",
  "NoneOfTheseWords": "都不是这些词",
  "Anytime": "任何时间",
  "InTheLast": "最后",
  "Days": "天",
  "Months": "月",
  "Month": "月",
  "Year": "年",
  "Between": "日期范围",
  "Language": "语言",
  "Size": "大小",
  "AtLeast": "至少",
  "AtMost": "至多",
  "Contains": "包含",
  "DoesNotContain": "不包含",
  "Matches": "匹配",
  "Bytes": "字节",
  "card": "卡片",
  "table": "表格",
  "ResultLinks": "结果链接",
  "EnableQuerySyntax": "启用查询语法",
  "On": "开",
  "Off": "关",
  "Automatic": "自动",
  "ResultsPerPage": "每一页的结果",
  "PreviousMonth": "上个月",
  "NextMonth": "下个月",
  "Title": "标题",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["zh-CN"] = merge(locales["zh-CN"], dict);
  String["toLocaleString"].call(this, { "zh-CN": dict });
  String["locale"] = "zh-CN";
  String["defaultLocale"] = "en";
  Globalize.culture("zh-CN")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "用户",
  "filetype_box user": "用户",
  "html": "HTML 文件",
  "filetype_html": "HTML 文件",
  "wiki": "维基百科",
  "filetype_wiki": "维基百科",
  "webscraperwebpage": "网页",
  "filetype_webscraperwebpage": "网页",
  "image": "图片",
  "filetype_image": "图片",
  "folder": "文件夹",
  "filetype_folder": "文件夹",
  "txt": "文本",
  "filetype_txt": "文本",
  "zip": "Zip 文件",
  "filetype_zip": "Zip 文件",
  "olefile": "OLE 文件",
  "filetype_olefile": "OLE 文件",
  "gmailmessage": "Gmail 消息",
  "filetype_gmailmessage": "Gmail 消息",
  "pdf": "PDF 文件",
  "filetype_pdf": "PDF 文件",
  "swf": "Flash 文件",
  "filetype_swf": "Flash 文件",
  "xml": "XML 文件",
  "filetype_xml": "XML 文件",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "打开 Office",
  "filetype_svm": "打开 Office",
  "rssitem": "RSS 源",
  "filetype_rssitem": "RSS 源",
  "doc": "文档",
  "filetype_doc": "文档",
  "docx": "Microsoft Word 文档",
  "filetype_docx": "Microsoft Word 文档",
  "xls": "电子数据表文档",
  "filetype_xls": "电子数据表文档",
  "ppt": "演示文档",
  "filetype_ppt": "演示文档",
  "video": "视频",
  "filetype_video": "视频",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "打开文本文档",
  "filetype_odt": "打开文本文档",
  "lithiummessage": "Lithium 消息",
  "filetype_lithiummessage": "Lithium 消息",
  "lithiumthread": "Lithium 线程",
  "filetype_lithiumthread": "Lithium 线程",
  "lithiumboard": "Lithium 保护板",
  "filetype_lithiumboard": "Lithium 保护板",
  "lithiumcategory": "Lithium 类别",
  "filetype_lithiumcategory": "Lithium 类别",
  "lithiumcommunity": "Lithium 社区",
  "filetype_lithiumcommunity": "Lithium 社区",
  "people": "用户",
  "objecttype_people": "用户",
  "message": "消息",
  "objecttype_message": "消息",
  "feed": "RSS 源",
  "objecttype_feed": "RSS 源",
  "thread": "线程",
  "objecttype_thread": "线程",
  "file": "文件",
  "objecttype_file": "文件",
  "board": "保护板",
  "objecttype_board": "保护板",
  "category": "类别",
  "objecttype_category": "类别",
  "account": "账户",
  "objecttype_account": "账户",
  "annotation": "注释",
  "objecttype_annotation": "注释",
  "campaign": "活动",
  "objecttype_campaign": "活动",
  "case": "案例",
  "objecttype_case": "案例",
  "contact": "联系",
  "objecttype_contact": "联系",
  "contract": "合同",
  "objecttype_contract": "合同",
  "event": "事件",
  "objecttype_event": "事件",
  "email": "电子邮件",
  "objecttype_email": "电子邮件",
  "goal": "目标",
  "objecttype_goal": "目标",
  "objecttype_incident": "案例",
  "invoice": "账单",
  "objecttype_invoice": "账单",
  "lead": "带领",
  "objecttype_lead": "带领",
  "list": "列表",
  "objecttype_list": "市场列表",
  "solution": "解决方案",
  "objecttype_solution": "解决方案",
  "task": "任务",
  "objecttype_task": "任务",
  "user": "用户",
  "objecttype_user": "用户",
  "attachment": "附件",
  "objecttype_attachment": "附件",
  "casecomment": "案例意见",
  "objecttype_casecomment": "案例意见",
  "opportunity": "机会",
  "objecttype_opportunity": "机会",
  "opportunityproduct": "机会产品",
  "objecttype_opportunityproduct": "机会产品",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "注释",
  "objecttype_note": "注释",
  "product": "产品",
  "objecttype_product": "产品",
  "partner": "合作伙伴",
  "objecttype_partner": "合作伙伴",
  "queueitem": "列队项目",
  "objecttype_queueitem": "列队项目",
  "quote": "引用",
  "objecttype_quote": "引用",
  "salesliterature": "销售说明书",
  "objecttype_salesliterature": "销售说明书",
  "salesorder": "销售订单",
  "objecttype_salesorder": "销售订单",
  "service": "服务",
  "objecttype_service": "服务",
  "socialprofile": "社会形象",
  "objecttype_socialprofile": "社会形象",
  "kbdocumentation": "文件",
  "objecttype_kbdocumentation": "文件",
  "kbtechnicalarticle": "文件",
  "objecttype_kbtechnicalarticle": "文件",
  "kbsolution": "解决方案",
  "objecttype_kbsolution": "解决方案",
  "kbknowledgearticle": "知识文章",
  "objecttype_kbknowledgearticle": "知识文章",
  "kbattachment": "附件",
  "objecttype_kbattachment": "附件",
  "kbarticle": "文章",
  "objecttype_kbarticle": "文章",
  "kbarticlecomment": "文章评论",
  "objecttype_kbarticlecomment": "文章评论",
  "knowledgearticle": "知识文章",
  "objecttype_knowledgearticle": "知识文章",
  "topic": "主题",
  "objecttype_topic": "主题",
  "dashboard": "仪表板",
  "objecttype_dashboard": "仪表板",
  "contentversion": "文档",
  "objecttype_contentversion": "文档",
  "collaborationgroup": "协作组",
  "objecttype_collaborationgroup": "协作组",
  "spportal": "入口",
  "filetype_spportal": "入口",
  "spsite": "站点",
  "filetype_spsite": "站点",
  "spuserprofile": "SharePoint 用户",
  "filetype_spuserprofile": "SharePoint 用户",
  "sparea": "区域",
  "filetype_sparea": "区域",
  "spannouncement": "公告",
  "filetype_spannouncement": "公告",
  "spannouncementlist": "公告",
  "filetype_spannouncementlist": "公告",
  "spcontact": "联系",
  "filetype_spcontact": "联系",
  "spcontactlist": "联系",
  "filetype_spcontactlist": "联系",
  "spcustomlist": "自定义列表",
  "filetype_spcustomlist": "自定义列表",
  "spdiscussionboard": "讨论板块",
  "filetype_spdiscussionboard": "讨论板块",
  "spdiscussionboardlist": "讨论板块",
  "filetype_spdiscussionboardlist": "讨论板块",
  "spdocumentlibrarylist": "文档库",
  "filetype_spdocumentlibrarylist": "文档库",
  "spevent": "事件",
  "filetype_spevent": "事件",
  "speventlist": "事件",
  "filetype_speventlist": "事件",
  "spformlibrarylist": "从库",
  "filetype_spformlibrarylist": "从库",
  "spissue": "问题",
  "filetype_spissue": "问题",
  "spissuelist": "问题",
  "filetype_spissuelist": "问题",
  "splink": "链接",
  "filetype_splink": "链接",
  "splinklist": "链接",
  "filetype_splinklist": "链接",
  "sppicturelibrarylist": "图片库",
  "filetype_sppicturelibrarylist": "图片库",
  "spsurvey": "调查",
  "filetype_spsurvey": "调查",
  "spsurveylist": "调查",
  "filetype_spsurveylist": "调查",
  "sptask": "任务",
  "filetype_sptask": "任务",
  "sptasklist": "任务",
  "filetype_sptasklist": "任务",
  "spagenda": "议程",
  "filetype_spagenda": "议程",
  "spagendalist": "议程",
  "filetype_spagendalist": "议程",
  "spattendee": "参会人",
  "filetype_spattendee": "参会人",
  "spattendeelist": "参会人",
  "filetype_spattendeelist": "参会人",
  "spcustomgridlist": "自定义网格",
  "filetype_spcustomgridlist": "自定义网格",
  "spdecision": "决定",
  "filetype_spdecision": "决定",
  "spdecisionlist": "决定",
  "filetype_spdecisionlist": "决定",
  "spobjective": "目的",
  "filetype_spobjective": "目的",
  "spobjectivelist": "目的",
  "filetype_spobjectivelist": "目的",
  "sptextbox": "文本框",
  "filetype_sptextbox": "文本框",
  "sptextboxlist": "文本框列表",
  "filetype_sptextboxlist": "文本框列表",
  "spthingstobring": "议题",
  "filetype_spthingstobring": "议题",
  "spthingstobringlist": "议题",
  "filetype_spthingstobringlist": "议题",
  "sparealisting": "区域列表",
  "filetype_sparealisting": "区域列表",
  "spmeetingserie": "会议系列",
  "filetype_spmeetingserie": "会议系列",
  "spmeetingserielist": "会议系列列表",
  "filetype_spmeetingserielist": "会议系列列表",
  "spsitedirectory": "站点目录项",
  "filetype_spsitedirectory": "站点目录项",
  "spsitedirectorylist": "站点目录",
  "filetype_spsitedirectorylist": "站点目录",
  "spdatasource": "数据源",
  "filetype_spdatasource": "数据源",
  "spdatasourcelist": "数据源列表",
  "filetype_spdatasourcelist": "数据源列表",
  "splisttemplatecataloglist": "列表模板库",
  "filetype_splisttemplatecataloglist": "列表模板库",
  "spwebpartcataloglist": "WebPart库",
  "filetype_spwebpartcataloglist": "WebPart库",
  "spwebtemplatecataloglist": "站点模板库",
  "filetype_spwebtemplatecataloglist": "站点模板库",
  "spworkspacepagelist": "工作区页面",
  "filetype_spworkspacepagelist": "工作区页面",
  "spunknownlist": "自定义列表",
  "filetype_spunknownlist": "自定义列表",
  "spadministratortask": "管理员任务",
  "filetype_spadministratortask": "管理员任务",
  "spadministratortasklist": "管理员任务",
  "filetype_spadministratortasklist": "管理员任务",
  "spareadocumentlibrarylist": "区域文档库",
  "filetype_spareadocumentlibrarylist": "区域文档库",
  "spblogcategory": "博客分类",
  "filetype_spblogcategory": "博客分类",
  "spblogcategorylist": "博客分类",
  "filetype_spblogcategorylist": "博客分类",
  "spblogcomment": "博客评论",
  "filetype_spblogcomment": "博客评论",
  "spblogcommentlist": "博客评论",
  "filetype_spblogcommentlist": "博客评论",
  "spblogpost": "博客帖子",
  "filetype_spblogpost": "博客帖子",
  "spblogpostlist": "博客帖子",
  "filetype_spblogpostlist": "博客帖子",
  "spdataconnectionlibrarylist": "数据连接库",
  "filetype_spdataconnectionlibrarylist": "数据连接库",
  "spdistributiongroup": "通讯组",
  "filetype_spdistributiongroup": "通讯组",
  "spdistributiongrouplist": "通讯组",
  "filetype_spdistributiongrouplist": "通讯组",
  "spipfslist": "InfoPath 表格服务器",
  "filetype_spipfslist": "InfoPath 表格服务器",
  "spkeyperformanceindicator": "关键性能指示器",
  "filetype_spkeyperformanceindicator": "关键性能指示器",
  "spkeyperformanceindicatorlist": "关键性能指示器",
  "filetype_spkeyperformanceindicatorlist": "关键性能指示器",
  "splanguagesandtranslator": "语言和翻译",
  "filetype_splanguagesandtranslator": "语言和翻译",
  "splanguagesandtranslatorlist": "语言和翻译",
  "filetype_splanguagesandtranslatorlist": "语言和翻译",
  "spmasterpagescataloglist": "主页面库",
  "filetype_spmasterpagescataloglist": "主页面库",
  "spnocodeworkflowlibrarylist": "无代码工作流程库",
  "filetype_spnocodeworkflowlibrarylist": "无代码工作流程库",
  "spprojecttask": "项目任务",
  "filetype_spprojecttask": "项目任务",
  "spprojecttasklist": "项目任务",
  "filetype_spprojecttasklist": "项目任务",
  "sppublishingpageslibrarylist": "页面库",
  "filetype_sppublishingpageslibrarylist": "页面库",
  "spreportdocumentlibrarylist": "报告文档库",
  "filetype_spreportdocumentlibrarylist": "报告文档库",
  "spreportlibrarylist": "报告库",
  "filetype_spreportlibrarylist": "报告库",
  "spslidelibrarylist": "滑动库",
  "filetype_spslidelibrarylist": "滑动库",
  "sptab": "标签",
  "filetype_sptab": "标签",
  "sptablist": "标签列表",
  "filetype_sptablist": "标签列表",
  "sptranslationmanagementlibrarylist": "翻译管理库",
  "filetype_sptranslationmanagementlibrarylist": "翻译管理库",
  "spuserinformation": "用户信息",
  "filetype_spuserinformation": "用户信息",
  "spuserinformationlist": "用户信息列表",
  "filetype_spuserinformationlist": "用户信息列表",
  "spwikipagelibrarylist": "维基百科页面库",
  "filetype_spwikipagelibrarylist": "维基百科页面库",
  "spworkflowhistory": "工作流程历史",
  "filetype_spworkflowhistory": "工作流程历史",
  "spworkflowhistorylist": "工作流程历史列表",
  "filetype_spworkflowhistorylist": "工作流程历史列表",
  "spworkflowprocess": "自定义工作流过程",
  "filetype_spworkflowprocess": "自定义工作流过程",
  "spworkflowprocesslist": "自定义工作流过程",
  "filetype_spworkflowprocesslist": "自定义工作流过程",
  "sppublishingimageslibrarylist": "发布图像库",
  "filetype_sppublishingimageslibrarylist": "发布图像库",
  "spcirculation": "循环",
  "filetype_spcirculation": "循环",
  "spcirculationlist": "循环",
  "filetype_spcirculationlist": "循环",
  "spdashboardslibrarylist": "仪表板库",
  "filetype_spdashboardslibrarylist": "仪表板库",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 数据连接库",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 数据连接库",
  "sphealthreport": "健康报告",
  "filetype_sphealthreport": "健康报告",
  "sphealthreportlist": "健康报告",
  "filetype_sphealthreportlist": "健康报告",
  "sphealthrule": "健康规则",
  "filetype_sphealthrule": "健康规则",
  "sphealthrulelist": "健康规则",
  "filetype_sphealthrulelist": "健康规则",
  "spimedictionary": "IME 字典",
  "filetype_spimedictionary": "IME 字典",
  "spimedictionarylist": "IME 字典",
  "filetype_spimedictionarylist": "IME 字典",
  "spperformancepointcontent": "PerformancePoint 内容",
  "filetype_spperformancepointcontent": "PerformancePoint 内容",
  "spperformancepointcontentlist": "PerformancePoint 内容",
  "filetype_spperformancepointcontentlist": "PerformancePoint 内容",
  "spphonecallmemo": "电话通话备忘录",
  "filetype_spphonecallmemo": "电话通话备忘录",
  "spphonecallmemolist": "电话通话备忘录",
  "filetype_spphonecallmemolist": "电话通话备忘录",
  "sprecordlibrarylist": "记录库",
  "filetype_sprecordlibrarylist": "记录库",
  "spresource": "资源",
  "filetype_spresource": "资源",
  "spresourcelist": "资源",
  "filetype_spresourcelist": "资源",
  "spprocessdiagramslibrarylist": "流程图库",
  "filetype_spprocessdiagramslibrarylist": "流程图库",
  "spsitethemeslibrarylist": "站点主题库",
  "filetype_spsitethemeslibrarylist": "站点主题库",
  "spsolutionslibrarylist": "解决方案库",
  "filetype_spsolutionslibrarylist": "解决方案库",
  "spwfpublibrarylist": "WFPUB 库",
  "filetype_spwfpublibrarylist": "WFPUB 库",
  "spwhereabout": "行踪",
  "filetype_spwhereabout": "行踪",
  "spwhereaboutlist": "行踪",
  "filetype_spwhereaboutlist": "行踪",
  "spdocumentlink": "链接到文档",
  "filetype_spdocumentlink": "链接到文档",
  "spdocumentset": "文件组",
  "filetype_spdocumentset": "文件组",
  "spmicrofeedpost": "Microfeed 帖子",
  "filetype_spmicrofeedpost": "Microfeed 帖子",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "列表文件夹",
  "filetype_splistfolder": "列表文件夹",
  "Unknown": "未知",
  "And": "与",
  "Authenticating": "验证 {0}...",
  "Clear": "清除 {0}",
  "CompleteQuery": "完整查询",
  "Exclude": "排除 {0}",
  "EnterTag": "添加标记",
  "Next": "下一页",
  "Last": "最后一页",
  "Link": "链接",
  "Or": "或",
  "Previous": "上一页",
  "QueryDidntMatchAnyDocuments": "您的查询与任何文档都不匹配。",
  "QueryException": "您的查询存在错误： {0}。",
  "Me": "我",
  "Remove": "删除",
  "Search": "搜索",
  "SearchFor": "搜索 {0}",
  "ShareQuery": "共享查询",
  "Preferences": "首选项",
  "LinkOpeningSettings": "链接打开设置",
  "Reauthenticate": "重新验证 {0}",
  "ResultsFilteringExpression": "结果筛选表达式",
  "FiltersInYourPreferences": "首选项中的筛选条件",
  "Create": "创建",
  "SearchIn": "在 {0} 中搜索",
  "Seconds": "用时 {0} 秒",
  "ShowingResultsOf": "结果数 {0}<pl>-{1}</pl>，总数 {2}",
  "ShowingResultsOfWithQuery": "结果数 {0}<pl>-{1}</pl>，总数 {2}, 搜索 {3}",
  "SwitchTo": "切换到 {0}",
  "Unexclude": "不排除 {0}",
  "ClearAllFilters": "清除所有筛选条件",
  "SkipLogin": "跳过登录",
  "LoginInProgress": "正在登录，请稍候...",
  "Login": "登录",
  "GetStarted": "开始体验",
  "More": "更多",
  "NMore": "{0} 更多...",
  "Less": "更少",
  "Settings": "设置",
  "Score": "得分",
  "ScoreDescription": "得分是根据出现次数和在结果集中的位置计算得来。",
  "Occurrences": "出现次数",
  "OccurrencesDescription": "按出现次数排序，出现次数最高的值排在首位。",
  "Label": "标签",
  "Of": "第...个，共...个",
  "LabelDescription": "对字段值按字母顺序排序。",
  "Value": "值",
  "ValueDescription": "按第一个计算得出的字段的值排序",
  "AlphaAscending": "值升序排序",
  "AlphaDescending": "值降序排序",
  "ChiSquare": "卡方值",
  "Nosort": "无排序",
  "NosortDescription": "不排序值。值将返回随机顺序排列。",
  "RelativeFrequency": "相对频率",
  "RelativeFrequencyDescription": "基于值的相对频率排序。较不常见的值将出现在较高位置。",
  "DateDistribution": "日期分布",
  "Custom": "自定义",
  "CustomDescription": "基于自定义顺序排序",
  "ComputedField": "计算得出的字段",
  "Ascending": "升序",
  "Descending": "降序",
  "noResultFor": "没有找到与 {0} 相关的结果",
  "autoCorrectedQueryTo": "查询自动更正为 {0}",
  "didYouMean": "您要找的是不是： {0}",
  "SuggestedResults": "建议的结果",
  "SuggestedQueries": "建议的查询",
  "MostRelevantItems": "最相关的项：",
  "AllItems": "所有项：",
  "ShowLess": "显示较少的值",
  "ShowMore": "显示较多的值",
  "HideFacet": "隐藏快捷控制界面",
  "ShowFacet": "显示快捷控制界面",
  "AndOthers": "以及 {0} 个其他项",
  "Others": "{0} 个其他项",
  "MostRelevantPosts": "最相关的帖子：",
  "CompleteThread": "完整的主题：",
  "ShowCompleteThread": "显示完整的主题",
  "ShowOnlyTopMatchingPosts": "仅显示最匹配的帖子",
  "MostRelevantReplies": "最相关的回复：",
  "AllConversation": "所有对话：",
  "ShowAllConversation": "显示所有对话",
  "ShowAllReplies": "显示所有回复",
  "ShowOnlyMostRelevantReplies": "仅显示最相关的回复",
  "Close": "关闭",
  "Open": "打开",
  "OpenInOutlookWhenPossible": "在 Outlook 中打开（如果可能）",
  "AlwaysOpenInNewWindow": "总是在新窗口中打开结果",
  "Quickview": "快速查看",
  "NoQuickview": "该文件无法快速浏览。",
  "ErrorReport": "错误报告",
  "OopsError": "服务器出现了错误。",
  "ProblemPersists": "如果问题仍然存在，请联系管理员。",
  "GoBack": "返回",
  "Reset": "重置",
  "Retry": "重试",
  "MoreInfo": "更多信息",
  "Username": "用户名",
  "Password": "密码",
  "PostedBy": "发贴者",
  "CannotConnect": "无法连接到该服务器地址。",
  "BadUserPass": "密码与用户名不匹配。",
  "PleaseEnterYourCredentials": "请输入您的 {0} 凭据。",
  "PleaseEnterYourSearchPage": "请输入您的搜索页面的网址",
  "Collapse": "折叠",
  "Collapsable": "可折叠",
  "Expand": "展开",
  "Today": "今天",
  "Yesterday": "昨天",
  "Tomorrow": "明天",
  "Duration": "持续时间： {0}",
  "IndexDuration": "索引持续时间： {0}",
  "ProxyDuration": "代理持续时间： {0}",
  "ClientDuration": "客户端持续时间： {0}",
  "Unavailable": "不可用",
  "Reply": "回复",
  "ReplyAll": "全部回复",
  "Forward": "转发",
  "From": "发件人",
  "Caption": "标题",
  "Expression": "表达式",
  "Tab": "选项卡",
  "Tabs": "多个选项卡",
  "EnterExpressionName": "输入表达式名称",
  "EnterExpressionToFilterWith": "输入用于筛选结果的表达式",
  "SelectTab": "选择选项卡",
  "SelectAll": "全选",
  "PageUrl": "搜索页面的网址",
  "ErrorSavingToDevice": "在将信息保存到您的设备时出错",
  "ErrorReadingFromDevice": "在从您的设备读取信息时出错",
  "AppIntro": "咨询能够回答您有关 Coveo 的问题的产品专家，并帮助您确定哪个 Coveo 解决方案适合您。或者，尝试现场演示！",
  "TryDemo": "尝试演示",
  "ContactUs": "联系我们",
  "NewToCoveo": "Coveo 的新用户？",
  "LetUsHelpGetStarted": "让我们帮助您开始体验",
  "LikesThis": "{0} 喜欢此解决方案。",
  "CannotConnectSearchPage": "无法连接到您的搜索页面",
  "AreYouSureDeleteFilter": "您是否确定要删除采用 {1} 表达式的筛选条件 {0}",
  "OnlineHelp": "在线帮助",
  "Done": "完成",
  "SaveFacetState": "保存此快捷控制界面状态",
  "ClearFacetState": "清除快捷控制界面状态",
  "DisplayingTheOnlyMessage": "仅显示此对话中的消息",
  "NoNetworkConnection": "没有网络连接",
  "UnknownConnection": "未知的连接",
  "EthernetConnection": "以太网连接",
  "WiFi": "WiFi 连接",
  "CELL": "移动连接",
  "CELL_2G": "移动 2G 连接",
  "CELL_3G": "移动 3G 连接",
  "CELL_4G": "移动 4G 连接",
  "Relevance": "关联",
  "Date": "日期",
  "Amount": "数量",
  "QueryExceptionNoException": "没有例外",
  "QueryExceptionInvalidSyntax": "无效语法",
  "QueryExceptionInvalidCustomField": "无效自定义字段",
  "QueryExceptionInvalidDate": "无效日期",
  "QueryExceptionInvalidExactPhrase": "无效精确短语",
  "QueryExceptionInvalidDateOp": "无效日期运算符",
  "QueryExceptionInvalidNear": "无效 NEAR 运算符",
  "QueryExceptionInvalidWeightedNear": "无效加权 NEAR",
  "QueryExceptionInvalidTerm": "无效条件",
  "QueryExceptionTooManyTerms": "太多条件",
  "QueryExceptionWildcardTooGeneral": "通配符太常见",
  "QueryExceptionInvalidSortField": "无效排序字段",
  "QueryExceptionInvalidSmallStringOp": "无效小字符串运算符",
  "QueryExceptionRequestedResultsMax": "要求的最大结果数",
  "QueryExceptionAggregatedMirrorDead": "远程聚合镜像处于离线状态",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "远程聚合镜像查询超时",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "远程聚合镜像无效版本号",
  "QueryExceptionAggregatedMirrorCannotConnect": "远程聚合镜像无法连接",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "主字符通配符不足",
  "QueryExceptionSecurityInverterNotFound": "未找到安全变换器",
  "QueryExceptionSecurityInverterAccessDenied": "安全变换器访问被拒绝",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "远程聚合镜像无法模拟",
  "QueryExceptionUnexpected": "意外",
  "QueryExceptionAccessDenied": "访问被拒绝",
  "QueryExceptionSuperUserTokenInvalid": "超级用户令牌无效",
  "QueryExceptionSuperUserTokenExpired": "超级用户令牌已过期",
  "QueryExceptionLicenseQueriesExpired": "查询许可证已过期",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "许可证超级用户令牌不支持",
  "QueryExceptionInvalidSession": "无效会话",
  "QueryExceptionInvalidDocument": "无效文档",
  "QueryExceptionSearchDisabled": "搜索被禁用",
  "FileType": "文件类型",
  "ShowAttachment": "显示附件",
  "OnFeed": "有关 {0} 的输入。",
  "Author": "作者",
  "NoTitle": "无标题",
  "CurrentSelections": "当前选择",
  "AllContent": "所有内容",
  "CancelLastAction": "取消最后一个动作",
  "SearchTips": "搜索提示",
  "CheckSpelling": "检查关键字的拼写。",
  "TryUsingFewerKeywords": "尝试使用更少、更常用或不同的关键字。",
  "SelectFewerFilters": "选择较少的筛选条件以扩大您的搜索范围。",
  "Document": "文件",
  "Time": "时间",
  "StartDate": "开始日期",
  "StartTime": "开始时间",
  "DurationTitle": "持续时间",
  "UserQuery": "用户查询",
  "ShowUserActions": "显示用户指令",
  "NoData": "无有效数据",
  "EventType": "事件类型",
  "GoToFullSearch": "全面搜索",
  "GoToEdition": "自定义界面",
  "RemoveContext": "清除内容",
  "BoxAttachToCase": "为案例添加附件",
  "AttachToCase": "为案例添加附件",
  "Attach": "附件",
  "Attached": "已添加附件",
  "Detach": "分离",
  "Details": "详细信息",
  "AdditionalFilters": "附加筛选器",
  "SelectNonContextualSearch": "从当前记录中清除内容，以扩大您的搜索",
  "CopyPasteToSupport": "复制并粘贴该消息至 Coveo 支持团队，以获取更多信息。",
  "FollowQueryDescription": "通知我更改查询结果。",
  "SearchAlerts_Panel": "管理通知",
  "SearchAlerts_PanelDescription": "查看并管理您的搜索通知。",
  "SearchAlerts_PanelNoSearchAlerts": "您尚未订阅。",
  "SearchAlerts_Fail": "当前搜索通知不可用。",
  "SearchAlerts_Type": "类型",
  "SearchAlerts_Content": "内容",
  "SearchAlerts_Actions": "指令",
  "EmptyQuery": "<empty>",
  "SearchAlerts_Type_followQuery": "查询",
  "SearchAlerts_Type_followDocument": "项目",
  "SearchAlerts_unFollowing": "停止遵循",
  "SearchAlerts_follow": "遵循",
  "SearchAlerts_followed": "已遵循",
  "SearchAlerts_followQuery": "遵循查询",
  "Subscription_StopFollowingQuery": "停止遵循查询",
  "SearchAlerts_Frequency": "时间",
  "SubscriptionsManageSubscriptions": "管理通知",
  "SubscriptionsMessageFollowQuery": "当查询 <b>{0}</b> 返回新项目或更新项目时，您将会收到通知。",
  "SubscriptionsMessageFollow": "您将会收到更改项目 <b>{0}</b> 的通知。",
  "Expiration": "到期时间",
  "Monthly": "月度",
  "Daily": "日常",
  "Monday": "星期一",
  "Tuesday": "星期二",
  "Wednesday": "星期三",
  "Thursday": "星期四",
  "Friday": "星期五",
  "Saturday": "星期六",
  "Sunday": "星期日",
  "NextDay": "下个 {0}",
  "LastDay": "上个 {0}",
  "StartTypingCaseForSuggestions": "描述您的问题，以查看可能的解决方案",
  "ExportToExcel": "导出到 Excel",
  "ExportToExcelDescription": "导出搜索结果到 Excel",
  "CaseCreationNoResults": "未找到可推荐的解决方案。",
  "SortBy": "排序方式",
  "BoxCreateArticle": "创建文章",
  "Facets": "小平面",
  "AdvancedSearch": "高级搜索",
  "Keywords": "关键词",
  "AllTheseWords": "全部词",
  "ExactPhrase": "精确匹配",
  "AnyOfTheseWords": "任意词",
  "NoneOfTheseWords": "都不是这些词",
  "Anytime": "任何时间",
  "InTheLast": "最后",
  "Days": "天",
  "Months": "月",
  "Month": "月",
  "Year": "年",
  "Between": "日期范围",
  "Language": "语言",
  "Size": "大小",
  "AtLeast": "至少",
  "AtMost": "至多",
  "Contains": "包含",
  "DoesNotContain": "不包含",
  "Matches": "匹配",
  "Bytes": "字节",
  "card": "卡片",
  "table": "表格",
  "ResultLinks": "结果链接",
  "EnableQuerySyntax": "启用查询语法",
  "On": "开",
  "Off": "关",
  "Automatic": "自动",
  "ResultsPerPage": "每一页的结果",
  "PreviousMonth": "上个月",
  "NextMonth": "下个月",
  "Title": "标题",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["zh-CN"] = merge(locales["zh-CN"], dict);
  String["toLocaleString"].call(this, { "zh-CN": dict });
  String["locale"] = "zh-CN";
  String["defaultLocale"] = "en";
  Globalize.culture("zh-CN")
}